﻿**** SPSS Syntax ****.

**** Descriptive Statistics ****.
*Centrality.
FREQUENCIES VARIABLES=money acres voting
/STATISTICS=MEAN MEDIAN MODE.
*Spread.
FREQUENCIES VARIABLES=money acres voting
 /NTILES=4 
 /STATISTICS VARIANCE STDDEV. 
* Correlations.
CORRELATIONS VARIABLES=money acres voting
/STATISTICS XPROD.

**** Data Preparation: Group- and Grand-Mean Centering ****.
AGGREGATE
/OUTFILE=* MODE=addvariables OVERWRITE=YES
/acres.grandmean = MEAN(acres)
/money.grandmean = MEAN(money).
COMPUTE acres.grandc=acres-acres.grandmean.
COMPUTE money.grandc=money-money.grandmean.
EXECUTE.

**** Example Regression Models, Not Accounting for Dependence ****.
COMPUTE moneyXacres = money.grandc*acres.grandc.
REGRESSION
/DEPENDENT voting
/METHOD=ENTER money.grandc acres.grandc moneyXacres.

**** Aggregation Demo ****.
*First, you have to create an aggregated dataset -- where each state is the observation -- to hold the aggregated means.
AGGREGATE
/OUTFILE='AGGREGATE.DATA.sav'
/BREAK = state
/money.groupmean=MEAN(money)
/acres.groupmean=MEAN(acres)
/voting.groupmean=MEAN(voting).
GET 
  FILE='AGGREGATE.DATA.sav'. 
DATASET NAME AGGREGATE.DATA WINDOW=FRONT.
AGGREGATE
/OUTFILE=* MODE=addvariables OVERWRITE=YES
/acres.grandmean = MEAN(acres.groupmean)
/money.grandmean = MEAN(money.groupmean).
COMPUTE acres.grandc=acres.groupmean-acres.grandmean.
COMPUTE money.grandc=money.groupmean-money.grandmean.
EXECUTE.

COMPUTE moneyXacres = money.grandc*acres.grandc.
REGRESSION
/DEPENDENT voting.groupmean
/METHOD=ENTER money.grandc acres.grandc moneyXacres.


* Need to reset our dataset back to the legislator data.
DATASET ACTIVATE DataSet1.

**** MULTILEVEL MODELING ****.
*Data Preparation: Group-Mean Centering Money and Effect-Coding the "house" covariate.
AGGREGATE
/OUTFILE=* MODE=addvariables
/BREAK = state
/money.groupmean=MEAN(money).
COMPUTE money.groupc=money-money.groupmean.
EXECUTE.

RECODE house (0=-1) (1=1) INTO house.effectc. 
EXECUTE.

* The following syntax runs a multilevel model with a random intercept, using the default "variance components" covariance matrix.
MIXED voting WITH acres.grandc money.groupc
  /FIXED=acres.grandc money.groupc acres.grandc*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT | SUBJECT(state).

*The following syntax estimates a random intercept and a random slope with an unstructured covariance matrix.
MIXED voting WITH acres.grandc money.groupc
  /FIXED=acres.grandc money.groupc acres.grandc*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).


*The following syntax estimates a random intercept and a random slope with an unstructured covariance matrix and a covariate.
MIXED voting WITH house.effectc acres.grandc money.groupc
  /FIXED=house.effectc acres.grandc money.groupc acres.grandc*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).

**** Simple Effects Testing with the Aiken & West (1991) Method ****.
* First, you have to create "high" and "low" values of each variable.
AGGREGATE
/OUTFILE=* MODE=addvariables
/money.sd=SD(money.groupc)
/acres.sd=SD(acres.grandc).
COMPUTE low.money=money.groupc+money.sd.
COMPUTE high.money=money.groupc-money.sd.
COMPUTE low.acres=acres.grandc+acres.sd.
COMPUTE high.acres=acres.grandc-acres.sd.
EXECUTE.

* The following model tests the simple slope of money when state acreage is low.
MIXED voting WITH house.effectc low.acres money.groupc
  /FIXED=house.effectc low.acres money.groupc low.acres*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).
* The following model tests the simple slope of money when state acreage is high.
MIXED voting WITH house.effectc high.acres money.groupc
  /FIXED=house.effectc high.acres money.groupc high.acres*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).
* The following model tests the simple slope of state acreage when money is low.
MIXED voting WITH house.effectc acres.grandc low.money money.groupc
  /FIXED=house.effectc acres.grandc low.money acres.grandc*low.money
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).
* The following model tests the simple slope of state acreage when money is high.
MIXED voting WITH house.effectc acres.grandc high.money money.groupc
  /FIXED=house.effectc acres.grandc high.money acres.grandc*high.money
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state) COVTYPE(UNR).

**** Baseline Model to Calculate Effect Size and ICC ****.
MIXED voting 
  /FIXED=INTERCEPT
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT | SUBJECT(state).

**** ADVANCED APPLICATIONS OF MLM ****.
**** N-level Models ****.
* 3-level model.
MIXED voting WITH house.effectc money.groupc acres.grandc
 /FIXED= house.effectc money.groupc acres.grandc money.groupc*acres.grandc
 /RANDOM=INTERCEPT money.groupc | SUBJECT(party*state)
 /RANDOM=INTERCEPT money.groupc | SUBJECT(party)
 /PRINT=SOLUTION.

*Nested Growth Curve Models (HYPOTHETICAL DATA) - Pretend that each legislator's vote on all pro-tobacco legislation was recorded (instead of the overall percentage) and the sequential order of each vote was stored in a variable called "time".
MIXED voting WITH money.groupc time
 /FIXED= money.groupc time money.groupc*time
 /RANDOM=INTERCEPT time | SUBJECT(state*legislator) COVTYPE(UNR)
 /RANDOM=INTERCEPT time | SUBJECT(state) COVTYPE(UNR)
 /PRINT=SOLUTION.

**** Generalized Linear Mixed Models ****.
*Generalized Linear Mixed Models - Poisson.
**Predicting the number of legislators from each state as a function of gross state product/economic productivity of state. 
GENLINMIXED
  /FIELDS TARGET=n_reps
  /TARGET_OPTIONS DISTRIBUTION=POISSON LINK=LOG
  /FIXED  EFFECTS=gsp USE_INTERCEPT =TRUE 
 /RANDOM USE_INTERCEPT =TRUE SUBJECTS =state.

*Generalized Linear Mixed Models - Multilevel logistic regression.
**Predicting party membership as a function of tobacco company donations.
GENLINMIXED
  /FIELDS TARGET=party
  /TARGET_OPTIONS REFERENCE =0 DISTRIBUTION=BINOMIAL LINK=LOGIT
  /FIXED  EFFECTS=voting USE_INTERCEPT =TRUE 
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=state.

**** Bootstrapping MLM ****.
* Below is an example with 1000 resamples.
BOOTSTRAP
  /VARIABLES TARGET=voting INPUT= acres.grandc money.groupc  
  /CRITERIA NSAMPLES=1000.
MIXED voting WITH acres.grandc money.groupc
  /FIXED=acres.grandc money.groupc acres.grandc*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT | SUBJECT(state).

**** Cross-Classified Models ****.
*Cross–classification (where representatives are nested within both state and party, but state and party are not hierarchically related).
MIXED voting WITH acres.grandc money.groupc
  /FIXED=acres.grandc money.groupc acres.grandc*money.groupc
  /PRINT=SOLUTION 
  /RANDOM=INTERCEPT money.groupc | SUBJECT(state)
  /RANDOM=INTERCEPT money.groupc| SUBJECT(party).
